/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import potionstudios.byg.BYG;
import potionstudios.byg.util.ModPlatform;
import potionstudios.byg.util.codec.CodecUtil;

public record BiomepediaClientData(Set<ResourceKey<Biome>> favoriteBiomes) {
    public static final BiomepediaClientData DEFAULT = new BiomepediaClientData((Set<ResourceKey<Biome>>)new ObjectOpenHashSet());
    public static BiomepediaClientData INSTANCE = null;
    private static final Supplier<Path> FILE_PATH = () -> ModPlatform.INSTANCE.configPath().getParent().resolve("client_data").resolve("byg").resolve("biomepedia.dat");
    private static final Codec<BiomepediaClientData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CodecUtil.BIOME_SET_CODEC.fieldOf("favorite_biomes").forGetter(biomepediaClientData -> biomepediaClientData.favoriteBiomes)).apply((Applicative)builder, BiomepediaClientData::new));

    public static BiomepediaClientData getConfig(boolean serialize) {
        if (INSTANCE == null || serialize) {
            INSTANCE = BiomepediaClientData.readConfig();
        }
        return INSTANCE;
    }

    private void save() {
        BiomepediaClientData.create(FILE_PATH.get(), this);
    }

    private static BiomepediaClientData readConfig() {
        Path path = FILE_PATH.get();
        if (!path.toFile().exists()) {
            BiomepediaClientData.create(path, DEFAULT);
        }
        BYG.LOGGER.info(String.format("\"%s\" was read.", path.toString()));
        try {
            return (BiomepediaClientData)((Pair)CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)NbtIo.m_128953_((File)path.toFile())).result().orElseThrow()).getFirst();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void create(Path path, BiomepediaClientData data) {
        Tag tag = (Tag)CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)data).result().orElseThrow();
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            NbtIo.m_128955_((CompoundTag)((CompoundTag)tag), (File)path.toFile());
        }
        catch (IOException e) {
            BYG.LOGGER.error(e.toString());
        }
    }
}

