/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.client;

import java.nio.file.Paths;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import potionstudios.byg.BYG;
import potionstudios.byg.BYGConstants;
import potionstudios.byg.client.gui.screen.HypogealImperiumScreen;
import potionstudios.byg.client.textures.renders.BYGParticleTypes;
import potionstudios.byg.common.container.BYGMenuTypes;
import potionstudios.byg.common.entity.boat.BYGBoatEntity;
import potionstudios.byg.common.entity.boat.BYGBoatRenderer;
import potionstudios.byg.common.particles.FallingLeafParticle;
import potionstudios.byg.common.particles.TheriumGlint;
import potionstudios.byg.mixin.access.client.MenuScreensAccess;
import potionstudios.byg.util.LangFileGenerator;

public class BYGClient {
    public static void load() {
        BYG.LOGGER.debug("BYG: \"Client Setup\" Event Starting...");
        if (BYGConstants.GENERATE_DATA) {
            LangFileGenerator.createLangFile(Paths.get("generated/en_us.json", new String[0]));
        }
        BYG.LOGGER.info("BYG: \"Client Setup\" Event Complete!");
    }

    public static void threadSafeLoad() {
        MenuScreensAccess.byg_register(BYGMenuTypes.HYPOGEAL_CONTAINER.get(), HypogealImperiumScreen::new);
    }

    public static void registerParticles(ParticleStrategy strategy) {
        strategy.register((ParticleType)BYGParticleTypes.THERIUM_GLINT.get(), TheriumGlint.Provider::new);
        strategy.register((ParticleType)BYGParticleTypes.WITCH_HAZEL_LEAF.get(), FallingLeafParticle.Provider::new);
        strategy.register((ParticleType)BYGParticleTypes.CHERRY_BLOSSOM_FALL_WHITE.get(), FallingLeafParticle.Provider::new);
        strategy.register((ParticleType)BYGParticleTypes.CHERRY_BLOSSOM_FALL_PINK.get(), FallingLeafParticle.Provider::new);
    }

    public static void registerLayerDefinitions(BiConsumer<ModelLayerLocation, Supplier<LayerDefinition>> consumer) {
        for (BYGBoatEntity.BYGType value : BYGBoatEntity.BYGType.values()) {
            consumer.accept(BYGBoatRenderer.createBoatModelName(value), BoatModel::m_170463_);
        }
    }

    public static interface ParticleStrategy {
        public <T extends ParticleOptions> void register(ParticleType<T> var1, ParticleEngine.SpriteParticleRegistration<T> var2);
    }
}

